#include <myUart.h>
#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>
#include <string.h>
#include "inc/hw_memmap.h"
#include "inc/hw_gpio.h"
#include "inc/hw_nvic.h"
#include "inc/hw_sysctl.h"
#include "inc/hw_types.h"
#include "driverlib/fpu.h"
#include "driverlib/gpio.h"
#include "driverlib/flash.h"
#include "driverlib/sysctl.h"
#include "driverlib/systick.h"
#include "driverlib/uart.h"
#include "driverlib/udma.h"
#include "driverlib/rom.h"
#include "grlib/grlib.h"
#include "grlib/widget.h"
#include "grlib/canvas.h"
#include "grlib/checkbox.h"
#include "grlib/container.h"
#include "grlib/pushbutton.h"
#include "grlib/radiobutton.h"
#include "grlib/slider.h"

#include "tm4c123gh6pm.h"
#include "lcd_tools/Kentec320x240x16_ssd2119_spi.h"
#include "lcd_tools/touch.h"

#include "InitializeFunctions.h"
#include "mySysTick.h"


int time_sys = 0;
int ch1Sample = 0;
int ch2Sample = 0;
int wave_point1,wave_point2;

// INitialize systick timmer with interrupt
void Systick_Init(void){
    DisableInterrupts() ;

    NVIC_ST_CTRL_R = 0;                             /* disable SysTick during setup */
    NVIC_ST_RELOAD_R = 159999;                       /* Reload Value goes here for 1 milli sec*/
    NVIC_SYS_PRI3_R = (NVIC_SYS_PRI3_R & 0x00FFFFFF) | 0xA0000000 ;
    NVIC_ST_CTRL_R |= 0x7;                          /* enable SysTick with core clock and interrupt enabled*/

    EnableInterrupts();
}

// NVIC_INT_CTRL_R |= 0x10000000;

///Systick Handler function

void SystickHandler(){
    //NVIC_INT_CTRL_R |= 0x10000000;
    time_sys++;

    //putInt(time_sys);
    if(time_sys % 2 == 0){
        sendFlagCh1 = true;
        sendFlagCh2 = false;
        time_sys = 0;
    }
    else{
        sendFlagCh2 = true;
        sendFlagCh1 = false;
    }
}

/*void PendSVHandler(){
    NVIC_INT_CTRL_R &= ~(0x10000000);
    if(time_sys % 2 == 0){
        sendUARTCh1Data();
        time_sys = 0;
    }
    else{
        sendUARTCh2Data();
    }
}
*/

// sending data for channel 1 through UART
/*
 * if nothing is set then 0.00 will be sent
 * */

void sendUARTCh1Data(){
    sendFlagCh1 = false;
    wave_point1 = (((int) (ch1Sample * freq)) % MAX_SAMPLES);
    putChar('1');
    putChar(',');
    switch (ch1)
    {
        case 'n':
            putFloat(amp*sine[wave_point1],2);
            break;
        case 's':
            putFloat(amp*square[wave_point1],2);
            break;
        case 't':
            putFloat(amp*tri[wave_point1],2);
            break;
        default:
            putFloat(0.00,2);
            break;
    }
    ch1Sample++;
    if (ch1Sample >= MAX_SAMPLES - 1)
         ch1Sample = 0;
}

// sending data for channel 2 through UART
/*
 * if nothing is set then 0.00 will be sent
 * */
void sendUARTCh2Data(){
    sendFlagCh2 = false;
    wave_point2 = (((int) (ch2Sample * freqCh2)) % MAX_SAMPLES);
    putChar('2');
    putChar(',');
    switch (ch2)
    {
        case 'n':
            putFloat(ampCh2*sine[wave_point2],2);
            break;
        case 's':
            putFloat(ampCh2*square[wave_point2],2);
            break;
        case 't':
            putFloat(ampCh2*tri[wave_point2],2);
            break;
        default:
            putFloat(0.00,2);
            break;
    }
    ch2Sample++;
    if (ch2Sample >= MAX_SAMPLES - 1)
        ch2Sample = 0;

}


